Ext.data.JsonP.sol_common_as_BarcodeUtils({"tagname":"class","name":"sol.common.as.BarcodeUtils","autodetected":{"aliases":true,"alternateClassNames":true,"extends":true,"mixins":true,"requires":true,"uses":true,"members":true,"code_type":true,"singleton":true},"files":[{"filename":"lib_sol.common.as.BarcodeUtils.js","href":"lib_sol.common.as.BarcodeUtils.html#sol-common-as-BarcodeUtils"}],"eloas":true,"version":["1.0"],"author":[{"tagname":"author","name":"MW, ELO Digital Office GmbH","email":null}],"aliases":{},"alternateClassNames":[],"extends":"sol.Base","mixins":[],"requires":[],"uses":[],"members":[{"name":"requiredConfig","tagname":"cfg","owner":"sol.Base","id":"cfg-requiredConfig","meta":{"protected":true}},{"name":"$className","tagname":"property","owner":"sol.Base","id":"property-S-className","meta":{"protected":true}},{"name":"logger","tagname":"property","owner":"sol.Base","id":"property-logger","meta":{"protected":true}},{"name":"$super","tagname":"method","owner":"sol.Base","id":"method-S-super","meta":{"private":true}},{"name":"convertByteArrayToBase64","tagname":"method","owner":"sol.common.as.BarcodeUtils","id":"method-convertByteArrayToBase64","meta":{"private":true}},{"name":"createCode39","tagname":"method","owner":"sol.common.as.BarcodeUtils","id":"method-createCode39","meta":{"private":true}},{"name":"createItfCode","tagname":"method","owner":"sol.common.as.BarcodeUtils","id":"method-createItfCode","meta":{"private":true}},{"name":"createOutput","tagname":"method","owner":"sol.common.as.BarcodeUtils","id":"method-createOutput","meta":{"private":true}},{"name":"createQrCode","tagname":"method","owner":"sol.common.as.BarcodeUtils","id":"method-createQrCode","meta":{"private":true}},{"name":"generate","tagname":"method","owner":"sol.common.as.BarcodeUtils","id":"method-generate","meta":{}},{"name":"initialize","tagname":"method","owner":"sol.Base","id":"method-initialize","meta":{"private":true}}],"code_type":"ext_define","singleton":true,"id":"class-sol.common.as.BarcodeUtils","classIcon":"icon-singleton","superclasses":["sol.Base"],"subclasses":[],"mixedInto":[],"parentMixins":[],"html":"<div><pre class=\"hierarchy\"><h4>Hierarchy</h4><div class='subclass first-child'><a href='#!/api/sol.Base' rel='sol.Base' class='docClass'>sol.Base</a><div class='subclass '><strong>sol.common.as.BarcodeUtils</strong></div></div><h4>Files</h4><div class='dependency'><a href='source/lib_sol.common.as.BarcodeUtils.html#sol-common-as-BarcodeUtils' target='_blank'>lib_sol.common.as.BarcodeUtils.js</a></div></pre><div class='doc-contents'><p>Barcode utilities</p>\n      <p class='version-tag'>Version: <b>1.0</b></p>\n</div><div class='members'><div class='members-section'><div class='definedBy'>Defined By</div><h3 class='members-title icon-cfg'>Config options</h3><div class='subsection'><div id='cfg-requiredConfig' class='member first-child inherited'><a href='#' class='side expandable'><span>&nbsp;</span></a><div class='title'><div class='meta'><a href='#!/api/sol.Base' rel='sol.Base' class='defined-in docClass'>sol.Base</a><br/><a href='source/lib_Class.html#sol-Base-cfg-requiredConfig' target='_blank' class='view-source'>view source</a></div><a href='#!/api/sol.Base-cfg-requiredConfig' class='name expandable'>requiredConfig</a> : Array<span class=\"signature\"><span class='protected' >protected</span></span></div><div class='description'><div class='short'>List of required config properties. ...</div><div class='long'><p>List of required config properties. <a href=\"#!/api/sol.Base-method-initialize\" rel=\"sol.Base-method-initialize\" class=\"docClass\">sol.Base.initialize</a> throws an exception if one of the properties is null or undefined.</p>\n</div></div></div></div></div><div class='members-section'><div class='definedBy'>Defined By</div><h3 class='members-title icon-property'>Properties</h3><div class='subsection'><div id='property-S-className' class='member first-child inherited'><a href='#' class='side expandable'><span>&nbsp;</span></a><div class='title'><div class='meta'><a href='#!/api/sol.Base' rel='sol.Base' class='defined-in docClass'>sol.Base</a><br/><a href='source/lib_Class.html#sol-Base-property-S-className' target='_blank' class='view-source'>view source</a></div><a href='#!/api/sol.Base-property-S-className' class='name expandable'>$className</a> : Object<span class=\"signature\"><span class='protected' >protected</span></span></div><div class='description'><div class='short'><p>{String}\nname of the class including its namespace.</p>\n</div><div class='long'><p>{String}\nname of the class including its namespace.</p>\n</div></div></div><div id='property-logger' class='member  inherited'><a href='#' class='side expandable'><span>&nbsp;</span></a><div class='title'><div class='meta'><a href='#!/api/sol.Base' rel='sol.Base' class='defined-in docClass'>sol.Base</a><br/><a href='source/lib_Class.html#sol-Base-property-logger' target='_blank' class='view-source'>view source</a></div><a href='#!/api/sol.Base-property-logger' class='name expandable'>logger</a> : <a href=\"#!/api/sol.Logger\" rel=\"sol.Logger\" class=\"docClass\">sol.Logger</a><span class=\"signature\"><span class='protected' >protected</span></span></div><div class='description'><div class='short'>Logger for this class instance. ...</div><div class='long'><p>Logger for this class instance. This logger is created by <a href=\"#!/api/sol.Base-method-initialize\" rel=\"sol.Base-method-initialize\" class=\"docClass\">sol.Base.initialize</a>.</p>\n\n<p>Please see <a href=\"#!/api/sol.Logger\" rel=\"sol.Logger\" class=\"docClass\">sol.Logger</a> class documentation for more information.</p>\n</div></div></div></div></div><div class='members-section'><div class='definedBy'>Defined By</div><h3 class='members-title icon-method'>Methods</h3><div class='subsection'><div id='method-S-super' class='member first-child inherited'><a href='#' class='side expandable'><span>&nbsp;</span></a><div class='title'><div class='meta'><a href='#!/api/sol.Base' rel='sol.Base' class='defined-in docClass'>sol.Base</a><br/><a href='source/lib_Class.html#sol-Base-method-S-super' target='_blank' class='view-source'>view source</a></div><a href='#!/api/sol.Base-method-S-super' class='name expandable'>$super</a>( <span class='pre'>superClassName, functionName, arguments</span> )<span class=\"signature\"><span class='private' >private</span></span></div><div class='description'><div class='short'>Calls a function of a superclass thanks to its name. ...</div><div class='long'><p>Calls a function of a superclass thanks to its name. Superclass must be part of the calling objects class hierarchy.</p>\n\n<p><b>Please note that calling superclass functions might lead to an infinitive loop if misused. Please validate that none class other than the classes superclass is passed as the superclass parent.</b></p>\n\n<pre><code>me.$super(superClassName, functionName, attributesArray);\n</code></pre>\n\n<p>A basic example of the initialize-function will look as followed.</p>\n\n<pre><code>me.$super(\"<a href=\"#!/api/sol.Base\" rel=\"sol.Base\" class=\"docClass\">sol.Base</a>\", \"initialize\", [config]);\nme.$super(\"<a href=\"#!/api/sol.Base\" rel=\"sol.Base\" class=\"docClass\">sol.Base</a>\", \"initialize\", arguments);\n</code></pre>\n\n<p>A word on performance: The superclass name must be passed since the js rhino engine does not allow accessing the caller of the callee due to performance reasons.</p>\n<h3 class=\"pa\">Parameters</h3><ul><li><span class='pre'>superClassName</span> : String<div class='sub-desc'><p>name of the super class.</p>\n</div></li><li><span class='pre'>functionName</span> : String<div class='sub-desc'><p>name of the function that should be called.</p>\n</div></li><li><span class='pre'>arguments</span> : Object[]<div class='sub-desc'><p>list of arguments that should be passed to the function.</p>\n</div></li></ul></div></div></div><div id='method-convertByteArrayToBase64' class='member  not-inherited'><a href='#' class='side expandable'><span>&nbsp;</span></a><div class='title'><div class='meta'><span class='defined-in' rel='sol.common.as.BarcodeUtils'>sol.common.as.BarcodeUtils</span><br/><a href='source/lib_sol.common.as.BarcodeUtils.html#sol-common-as-BarcodeUtils-method-convertByteArrayToBase64' target='_blank' class='view-source'>view source</a></div><a href='#!/api/sol.common.as.BarcodeUtils-method-convertByteArrayToBase64' class='name expandable'>convertByteArrayToBase64</a>( <span class='pre'>byteArray</span> ) : String<span class=\"signature\"><span class='private' >private</span></span></div><div class='description'><div class='short'>Converts a byte array to a Base64 encoded string ...</div><div class='long'><p>Converts a byte array to a Base64 encoded string</p>\n<h3 class=\"pa\">Parameters</h3><ul><li><span class='pre'>byteArray</span> : java.lang.Byte[]<div class='sub-desc'>\n</div></li></ul><h3 class='pa'>Returns</h3><ul><li><span class='pre'>String</span><div class='sub-desc'><p>Base 64 encoded string</p>\n</div></li></ul></div></div></div><div id='method-createCode39' class='member  not-inherited'><a href='#' class='side expandable'><span>&nbsp;</span></a><div class='title'><div class='meta'><span class='defined-in' rel='sol.common.as.BarcodeUtils'>sol.common.as.BarcodeUtils</span><br/><a href='source/lib_sol.common.as.BarcodeUtils.html#sol-common-as-BarcodeUtils-method-createCode39' target='_blank' class='view-source'>view source</a></div><a href='#!/api/sol.common.as.BarcodeUtils-method-createCode39' class='name expandable'>createCode39</a>( <span class='pre'>content, config</span> ) : com.google.zxing.common.BitMatrix<span class=\"signature\"><span class='private' >private</span></span></div><div class='description'><div class='short'>Creates a Code 39 barcode ...</div><div class='long'><p>Creates a Code 39 barcode</p>\n<h3 class=\"pa\">Parameters</h3><ul><li><span class='pre'>content</span> : String<div class='sub-desc'><p>Content</p>\n</div></li><li><span class='pre'>config</span> : Object<div class='sub-desc'><p>Configuration</p>\n</div></li></ul><h3 class='pa'>Returns</h3><ul><li><span class='pre'>com.google.zxing.common.BitMatrix</span><div class='sub-desc'>\n</div></li></ul></div></div></div><div id='method-createItfCode' class='member  not-inherited'><a href='#' class='side expandable'><span>&nbsp;</span></a><div class='title'><div class='meta'><span class='defined-in' rel='sol.common.as.BarcodeUtils'>sol.common.as.BarcodeUtils</span><br/><a href='source/lib_sol.common.as.BarcodeUtils.html#sol-common-as-BarcodeUtils-method-createItfCode' target='_blank' class='view-source'>view source</a></div><a href='#!/api/sol.common.as.BarcodeUtils-method-createItfCode' class='name expandable'>createItfCode</a>( <span class='pre'>content, config</span> ) : com.google.zxing.common.BitMatrix<span class=\"signature\"><span class='private' >private</span></span></div><div class='description'><div class='short'>Creates a Code ITF barcode (Interleaved 5 of 2) ...</div><div class='long'><p>Creates a Code ITF barcode (Interleaved 5 of 2)</p>\n<h3 class=\"pa\">Parameters</h3><ul><li><span class='pre'>content</span> : String<div class='sub-desc'><p>Content</p>\n</div></li><li><span class='pre'>config</span> : Object<div class='sub-desc'><p>Configuration</p>\n</div></li></ul><h3 class='pa'>Returns</h3><ul><li><span class='pre'>com.google.zxing.common.BitMatrix</span><div class='sub-desc'>\n</div></li></ul></div></div></div><div id='method-createOutput' class='member  not-inherited'><a href='#' class='side expandable'><span>&nbsp;</span></a><div class='title'><div class='meta'><span class='defined-in' rel='sol.common.as.BarcodeUtils'>sol.common.as.BarcodeUtils</span><br/><a href='source/lib_sol.common.as.BarcodeUtils.html#sol-common-as-BarcodeUtils-method-createOutput' target='_blank' class='view-source'>view source</a></div><a href='#!/api/sol.common.as.BarcodeUtils-method-createOutput' class='name expandable'>createOutput</a>( <span class='pre'>bitMatrix, config</span> ) : String<span class=\"signature\"><span class='private' >private</span></span></div><div class='description'><div class='short'>Produces the barcode output ...</div><div class='long'><p>Produces the barcode output</p>\n<h3 class=\"pa\">Parameters</h3><ul><li><span class='pre'>bitMatrix</span> : com.google.zxing.common.BitMatrix<div class='sub-desc'>\n</div></li><li><span class='pre'>config</span> : Object<div class='sub-desc'><p>Configuration</p>\n</div></li></ul><h3 class='pa'>Returns</h3><ul><li><span class='pre'>String</span><div class='sub-desc'>\n</div></li></ul></div></div></div><div id='method-createQrCode' class='member  not-inherited'><a href='#' class='side expandable'><span>&nbsp;</span></a><div class='title'><div class='meta'><span class='defined-in' rel='sol.common.as.BarcodeUtils'>sol.common.as.BarcodeUtils</span><br/><a href='source/lib_sol.common.as.BarcodeUtils.html#sol-common-as-BarcodeUtils-method-createQrCode' target='_blank' class='view-source'>view source</a></div><a href='#!/api/sol.common.as.BarcodeUtils-method-createQrCode' class='name expandable'>createQrCode</a>( <span class='pre'>content, config</span> ) : com.google.zxing.common.BitMatrix<span class=\"signature\"><span class='private' >private</span></span></div><div class='description'><div class='short'>Creates a QR code ...</div><div class='long'><p>Creates a QR code</p>\n<h3 class=\"pa\">Parameters</h3><ul><li><span class='pre'>content</span> : String<div class='sub-desc'><p>Content</p>\n</div></li><li><span class='pre'>config</span> : Object<div class='sub-desc'><p>Configuration</p>\n</div></li></ul><h3 class='pa'>Returns</h3><ul><li><span class='pre'>com.google.zxing.common.BitMatrix</span><div class='sub-desc'>\n</div></li></ul></div></div></div><div id='method-generate' class='member  not-inherited'><a href='#' class='side expandable'><span>&nbsp;</span></a><div class='title'><div class='meta'><span class='defined-in' rel='sol.common.as.BarcodeUtils'>sol.common.as.BarcodeUtils</span><br/><a href='source/lib_sol.common.as.BarcodeUtils.html#sol-common-as-BarcodeUtils-method-generate' target='_blank' class='view-source'>view source</a></div><a href='#!/api/sol.common.as.BarcodeUtils-method-generate' class='name expandable'>generate</a>( <span class='pre'>type, content, config</span> ) : Object<span class=\"signature\"></span></div><div class='description'><div class='short'>Generates a barcode ...</div><div class='long'><p>Generates a barcode</p>\n<h3 class=\"pa\">Parameters</h3><ul><li><span class='pre'>type</span> : String<div class='sub-desc'><p>Barcode type. Supported types: QR_CODE, CODE_39, ITF</p>\n</div></li><li><span class='pre'>content</span> : String<div class='sub-desc'><p>Content</p>\n</div></li><li><span class='pre'>config</span> : String<div class='sub-desc'><p>Configuration</p>\n<ul><li><span class='pre'>width</span> : Number<div class='sub-desc'><p>Image width</p>\n</div></li><li><span class='pre'>height</span> : Number<div class='sub-desc'><p>Image height</p>\n</div></li><li><span class='pre'>filePath</span> : String<div class='sub-desc'><p>Path of the destination file</p>\n</div></li><li><span class='pre'>returnBase64</span> : Boolean<div class='sub-desc'><p>If true the function returns the barcode as Base64 encoded string</p>\n</div></li></ul></div></li></ul><h3 class='pa'>Returns</h3><ul><li><span class='pre'>Object</span><div class='sub-desc'><h1>Example</h1>\n\n<pre><code>base64String = <a href=\"#!/api/sol.common.as.BarcodeUtils-method-generate\" rel=\"sol.common.as.BarcodeUtils-method-generate\" class=\"docClass\">sol.common.as.BarcodeUtils.generate</a>(\"CODE_39\", \"12345678\", { width: 200, height: 50, returnBase64: true });\n</code></pre>\n</div></li></ul></div></div></div><div id='method-initialize' class='member  inherited'><a href='#' class='side expandable'><span>&nbsp;</span></a><div class='title'><div class='meta'><a href='#!/api/sol.Base' rel='sol.Base' class='defined-in docClass'>sol.Base</a><br/><a href='source/lib_Class.html#sol-Base-method-initialize' target='_blank' class='view-source'>view source</a></div><a href='#!/api/sol.Base-method-initialize' class='name expandable'>initialize</a>( <span class='pre'>config</span> )<span class=\"signature\"><span class='private' >private</span></span></div><div class='description'><div class='short'>Initialize class. ...</div><div class='long'><p>Initialize class.\nThis function is called after the class was instantiated.</p>\n<h3 class=\"pa\">Parameters</h3><ul><li><span class='pre'>config</span> : Object<div class='sub-desc'><p>parameters as defined. See documentation for more details.</p>\n</div></li></ul></div></div></div></div></div></div></div>","meta":{"eloas":true,"singleton":true}});